# Vraimony WordPress Plugin (FREE)

**Name:** Vraimony Verify Widget (by GetEvidex)

**Purpose (PLG wedge):** help WooCommerce merchants reduce disputes/chargebacks by embedding **verify-only** UI and linking to the **WooCommerce Dispute Evidence Bundle**.

## What it is
- **iframe-only** embeds to `https://verify.getevidex.net` (verify is always free, read-only, no login).
- **No tracking**: no analytics cookies, no fingerprinting, no per-user identifiers.
- **No remote scripts**: the plugin itself ships no remote JS; it only renders an iframe.

## Shortcodes

### 1) Verify Widget embed
Embed the Verify Widget (minimal/expanded view). Optionally provide a Receipt ID.

```
[vraimony_verify_widget rid="RECEIPT_ID" view="minimal" height="520" width="720"]
```

- `rid` (optional): Receipt ID to load in the widget.
- `view`: `minimal` or `expanded`.

### 2) Evidence Bundle links (WooCommerce disputes)
Renders safe links to generate **court-friendly** artifacts.

```
[vraimony_evidence_bundle rid="RECEIPT_ID"]
```

Links open on `verify.getevidex.net`:
- **Generate Evidence Bundle** (Transaction Pack)
- **Open Court Mode**
- **Open Verify**

## Install
1. WordPress Admin → Plugins → Add New → Upload Plugin.
2. Upload the ZIP you downloaded from Vraimony → Install → Activate.
3. Add the shortcode(s) to a page, an email template, or an order-status page.

## Reality Audit (disclaimer)
Integrity verification only (tamper-evident).
- No legal advice.
- No guarantee of admissibility/court acceptance.
- Does not prove truth, identity, authorship, delivery/condition, or intent.
- Verify page is the source of truth.


## Authority
- Vraimony Standard Seal (integrity-only): https://getevidex.net/standard.html#protocol
- Trust Center: https://getevidex.net/trust-center.html
- Daily Transparency Snapshot: https://getevidex.net/transparency.html

Daily Transparency Snapshot is an integrity-only daily signed checkpoint. It is NOT Certificate Transparency (RFC 6962) and does not provide inclusion/consistency proofs.
